## Sid Meier's Civilization 4
## Copyright Firaxis Games 2008

from CvPythonExtensions import *
import CvUtil
import ScreenInput
import CvScreenEnums

# Modified by Solver for Col v1

# globals
gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()

# this class is shared by both the resource and technology foreign advisors
class CvCongressAdvisor:
	"Congress Advisor Screen"

	def __init__(self):
		self.SCREEN_NAME = "CongressAdvisor"
		self.BACKGROUND_ID = "CongressAdvisorBackground"

		self.XResolution = 0
		self.YResolution = 0

		self.PICTURE_FF = 3
		self.BIG_PICTURE_FF = 4
		self.BIGFF = 0
		
		
	def interfaceScreen (self):

		self.player = gc.getPlayer(gc.getGame().getActivePlayer())
		self.team = gc.getTeam(self.player.getTeam())

		screen = self.getScreen()
		if screen.isActive():
			return

		self.MyFathers = []
		self.XResolution = self.getScreen().getXResolution()
		self.YResolution = self.getScreen().getYResolution()
		
		screen.setRenderInterfaceOnly(True);
		screen.showScreen(PopupStates.POPUPSTATE_IMMEDIATE, False)

		# Set the background and exit button, and show the screen
		screen.setDimensions(0, 0, self.XResolution, self.YResolution)
		screen.addDDSGFC(self.BACKGROUND_ID, ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BG").getPath(), 0, 0, self.XResolution, self.YResolution, WidgetTypes.WIDGET_GENERAL, -1, -1 )

		#screen.addDDSGFC("TopPanel", ArtFileMgr.getInterfaceArtInfo("INTERFACE_SCREEN_TITLE").getPath(), 0, 0, self.XResolution, 55, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		#screen.addDDSGFC("BottomPanel", ArtFileMgr.getInterfaceArtInfo("INTERFACE_SCREEN_TAB_OFF").getPath(), 0, self.YResolution - 55, self.XResolution, 55, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.addDDSGFCAt("BottomBGPanel" + str(1), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CITY_BG_TOP").getPath(), 0, self.YResolution - 45, self.XResolution, 45, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
		screen.showWindowBackground(False)

		TitleText = localText.getText("TXT_KEY_CONGRESS_ADVISOR_TITLE", ()).upper()
		TitleText = localText.changeTextColor(TitleText, gc.getInfoTypeForString("COLOR_FONT_CREAM"))

		screen.setLabel( "Title", "Background", u"<font=4b>" + TitleText + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, self.XResolution / 2, 4, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setText( "CongressScreenExit", "Background", u"<font=4>" + CyTranslator().getText("TXT_KEY_PEDIA_SCREEN_EXIT", ()).upper() + "</font>", CvUtil.FONT_RIGHT_JUSTIFY, self.XResolution - 30, self.YResolution - 35, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_CLOSE_SCREEN, -1, -1 )
		screen.setActivation( "CongressScreenExit", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )

		ArrowButtonSize = 55
		screen.setButtonGFC("ScrollMinus", u"", "", self.XResolution / 4 - ArrowButtonSize, self.YResolution - 50, ArrowButtonSize, ArrowButtonSize, WidgetTypes.WIDGET_GENERAL, 1, -1, ButtonStyles.BUTTON_STYLE_ARROW_LEFT )
		screen.setButtonGFC("ScrollPlus", u"", "", self.XResolution * 3 / 4, self.YResolution - 50, ArrowButtonSize, ArrowButtonSize, WidgetTypes.WIDGET_GENERAL, 2, -1, ButtonStyles.BUTTON_STYLE_ARROW_RIGHT )

		self.FatherColumn = 0
		self.ButtonClick = 0
		self.lastIndex = 999
		
		self.drawContents()
		return 0

	def getScreen(self):
		return CyGInterfaceScreen(self.SCREEN_NAME, CvScreenEnums.CONGRESS_ADVISOR)
		
	def getActualColumnCount(self):
		return ((len(self.MyFathers) + 1) / 2)

	def drawContents(self):
		screen = self.getScreen()
				
		iRow = 0
		self.MaxColumnCount = 50
		iRecordHight = ((self.YResolution - 110) / 2) - 5
		iRecordWidth = ((self.XResolution - 15) / 5) * 19 / 20
		PortraitSize = int(iRecordWidth * 1.25)
		PortraitBorder = PortraitSize / 20

		self.MyFathers = []
		self.MySortedFathers = []
		
		for iFather in range(gc.getNumFatherInfos()):
			Father = gc.getFatherInfo(iFather)
			if (gc.getGame().getFatherTeam(iFather) == self.team.getID()):
				self.MyFathers.append(iFather)
				#iFatherTurn = CyGame().getFatherGameTurn(iFather)
				#self.MySortedFathers.append(iFather)
		
		#if (self.FatherColumn == 0) or (self.getActualColumnCount() <= self.MaxColumnCount):
			#screen.hide("ScrollMinus")
		#else:
		screen.show("ScrollMinus")

		#if (self.FatherColumn == self.getActualColumnCount() - self.MaxColumnCount) or (self.getActualColumnCount() <= self.MaxColumnCount):
		#	screen.hide("ScrollPlus")
		#else:
		screen.show("ScrollPlus")

		#iColumn = 0
		#for iColumn in range(self.MaxColumnCount):
		#	screen.addDDSGFCAt("Portrait Box" + str((2 * iColumn) + 0), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (iRecordWidth * iColumn) + (PortraitBorder * (iColumn + 1)), (iRecordHight * 0) + 55, iRecordWidth , iRecordHight, WidgetTypes.WIDGET_GENERAL, -1, -1, False)

		#iColumn = 0
		#for iColumn in range(self.MaxColumnCount):
		#	screen.addDDSGFCAt("Portrait Box" + str((2 * iColumn) + 1), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (iRecordWidth * iColumn) + (PortraitBorder * (iColumn + 1)), (iRecordHight * 1) + 55, iRecordWidth , iRecordHight, WidgetTypes.WIDGET_GENERAL, -1, -1, False)


		FatherCountText = localText.getText("TXT_KEY_MEMBERS", (CyGameTextMgr().getInterfaceTimeStr(gc.getGame().getActivePlayer()), len(self.MyFathers)))
		FatherCountText = localText.changeTextColor(FatherCountText, gc.getInfoTypeForString("COLOR_FONT_GOLD"))
		screen.setLabel("FatherCount", "Background", "<font=4>" + FatherCountText + "</font>", CvUtil.FONT_CENTER_JUSTIFY, self.XResolution / 2, self.YResolution - 35, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		iColumn = 0
		iPosition = 1
		extra_add = 0
		iDrawAll = 0
		iIndex0 = 0
		iIndexA = 0
		iIndexB = 0
		iIndexC = 0
		
		for iIndex in range(self.MaxColumnCount * 2):
			iFatherIndex = iIndex + (self.FatherColumn * 2)
			if (iFatherIndex < len(self.MyFathers)):
				iFather = self.MyFathers[iIndex + (self.FatherColumn * 2)]
				iFatherTurn = CyGame().getFatherGameTurn(iFather)
				iFatherYear = CyGame().getTurnYear(iFatherTurn)
				
				screen.hide("Portrait Black" + str(iIndex))
				screen.hide("Portrait" + str(iIndex))
				screen.hide("Portrait Box" + str(iIndex))					
				
				#if (iIndex % 4 == 0) and (iIndex + 4) > len(self.MyFathers)):
				if ((iIndex + 4) %4 == 0 and self.ButtonClick == 0):
					
					self.lastIndex = iIndex
					
		
		#screen.addMultilineText(self.roomDigit, (iRecordWidth * iColumn) + (PortraitBorder * (iColumn + 1)), (iRecordHight * iRow) + 20 + (iRecordHight * 3 / 5), iRecordWidth, (iRecordHight * 18 / 100), WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_CENTER_JUSTIFY)
		#szFatherTitle = u" (%d)" %iIndex
				
		#fontSize = "<font=4>"
				
		#	if (len(szFatherTitle) > 30):
		#			fontSize = "<font=3>"
					
		#szFatherTitle = localText.changeTextColor(szFatherTitle, gc.getInfoTypeForString("COLOR_FONT_CREAM"))
				
		#screen.addMultilineText("FatherName" + str(iIndex), szFatherTitle, 50, 50, iRecordWidth, (iRecordHight * 18 / 100), WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_CENTER_JUSTIFY)

				#szFatherData = u"<font=2>" + CyGameTextMgr().getFatherHelp(iFather, True)[1:] + u"</font>"
				#screen.attachMultilineTextAt("Portrait Box" + str(iIndex), "FatherInfo" + str(iIndex), szFatherData, 0, (iRecordHight * 2 / 3) + 5, iRecordWidth, (iRecordHight / 3) - 14, WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_CENTER_JUSTIFY)

		iPosition = 1
		extra_add = 0
			
		iIndex0 = self.lastIndex
		
		iRoomDigit = ["I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XIX", "XX", "XXI", "XXII", "XXIII"]
				
		if (iIndex0 <= len(self.MyFathers)):
			screen.addDDSGFCAt("Portrait Black" + str(iIndex0), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_BLACK").getPath(), (self.XResolution / 6) * iPosition - PortraitSize / 3 + extra_add, self.YResolution / 2 - self.YResolution / 6, PortraitSize / 3, PortraitSize * 11 / 20, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			screen.addDDSGFCAt("Portrait" + str(iIndex0), "Background", gc.getFatherInfo(self.MyFathers[iIndex0 + (self.FatherColumn * 2)]).getPortrait(), (self.XResolution / 6) * iPosition - PortraitSize * 13 / 28 + extra_add, self.YResolution / 2 - self.YResolution / 7, PortraitSize * 3 / 5, PortraitSize * 3 / 5, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			screen.setImageButtonAt("Portrait Box" + str(iIndex0), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (self.XResolution / 6) * iPosition - PortraitSize * 21 / 48 + extra_add, self.YResolution / 2 - self.YResolution * 2 / 11, PortraitSize * 13 / 24, PortraitSize * 2 / 3, WidgetTypes.WIDGET_GENERAL, self.PICTURE_FF, iIndex0)
			#screen.addDDSGFCAt("Portrait Box" + str(iIndex0), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (self.XResolution / 6) * iPosition - PortraitSize * 21 / 48 + extra_add, PortraitSize * 3 / 4 + self.XResolution / 17, PortraitSize * 13 / 24, PortraitSize * 2 / 3, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
						
			#szFatherData = u"<font=2>" + CyGameTextMgr().getFatherHelp(iFather, True)[1:] + u"</font>"
			#screen.attachMultilineTextAt("Portrait Box" + str(iIndex0), "FatherInfo" + str(iIndex0), szFatherData, 0, (iRecordHight * 2 / 3) + 5, iRecordWidth, (iRecordHight / 3) - 14, WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_CENTER_JUSTIFY)

			fontSize = "<font=4>"
			szFatherTitle = iRoomDigit[iIndex0 / 4]
			szFatherTitle = localText.changeTextColor(szFatherTitle, gc.getInfoTypeForString("COLOR_FONT_GOLD"))
			screen.addMultilineText("FatherName" + str(iIndex),fontSize + szFatherTitle + "</font>", self.XResolution / 2 - iRecordWidth / 2, self.YResolution * 2 / 9, iRecordWidth, (iRecordHight * 18 / 100), WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_CENTER_JUSTIFY)
					
		iRow += 1
		iPosition += 1
		iIndexA = self.lastIndex + 1
		
	
		if (iIndexA < len(self.MyFathers)):
			screen.addDDSGFCAt("Portrait Black" + str(iIndexA), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_BLACK").getPath(), (self.XResolution / 6) * iPosition - PortraitSize / 3 + extra_add, self.YResolution / 2 - self.YResolution / 6, PortraitSize / 3, PortraitSize * 11 / 20, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			screen.addDDSGFCAt("Portrait" + str(iIndexA), "Background", gc.getFatherInfo(self.MyFathers[iIndexA + (self.FatherColumn * 2)]).getPortrait(), (self.XResolution / 6) * iPosition - PortraitSize * 13 / 28 + extra_add, self.YResolution / 2 - self.YResolution / 7, PortraitSize * 3 / 5, PortraitSize * 3 / 5, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			#screen.addDDSGFCAt("Portrait Box" + str(iIndexA), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (self.XResolution / 6) * iPosition - PortraitSize * 21 / 48 + extra_add, PortraitSize * 3 / 4 + self.XResolution / 17, PortraitSize * 13 / 24, PortraitSize * 2 / 3, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			screen.setImageButtonAt("Portrait Box" + str(iIndexA), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (self.XResolution / 6) * iPosition - PortraitSize * 21 / 48 + extra_add, self.YResolution / 2 - self.YResolution * 2 / 11, PortraitSize * 13 / 24, PortraitSize * 2 / 3, WidgetTypes.WIDGET_GENERAL, self.PICTURE_FF, iIndexA)
				
		iRow+= 1
		iPosition += 2
		extra_add = self.XResolution / 12
		iIndexB = self.lastIndex + 2
					
		if (iIndexB < len(self.MyFathers)):
			screen.addDDSGFCAt("Portrait Black" + str(iIndexB), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_BLACK").getPath(), (self.XResolution / 6) * iPosition - PortraitSize / 3 + extra_add, self.YResolution / 2 - self.YResolution / 6, PortraitSize / 3, PortraitSize * 11 / 20, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			screen.addDDSGFCAt("Portrait" + str(iIndexB), "Background", gc.getFatherInfo(self.MyFathers[iIndexB + (self.FatherColumn * 2)]).getPortrait(), (self.XResolution / 6) * iPosition - PortraitSize * 13 / 28 + extra_add, self.YResolution / 2 - self.YResolution / 7, PortraitSize * 3 / 5, PortraitSize * 3 / 5, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			#screen.addDDSGFCAt("Portrait Box" + str(iIndexB), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (self.XResolution / 6) * iPosition - PortraitSize * 21 / 48 + extra_add, PortraitSize * 3 / 4 + self.XResolution / 17, PortraitSize * 13 / 24, PortraitSize * 2 / 3, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			screen.setImageButtonAt("Portrait Box" + str(iIndexB), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (self.XResolution / 6) * iPosition - PortraitSize * 21 / 48 + extra_add, self.YResolution / 2 - self.YResolution * 2 / 11, PortraitSize * 13 / 24, PortraitSize * 2 / 3, WidgetTypes.WIDGET_GENERAL, self.PICTURE_FF, iIndexB)
					
		iRow += 1
		iPosition += 1
		iIndexC = self.lastIndex + 3
					
		if (iIndexC < len(self.MyFathers)):
			screen.addDDSGFCAt("Portrait Black" + str(iIndexC), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_BLACK").getPath(), (self.XResolution / 6) * iPosition - PortraitSize / 3 + extra_add, self.YResolution / 2 - self.YResolution / 6, PortraitSize / 3, PortraitSize * 11 / 20, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			screen.addDDSGFCAt("Portrait" + str(iIndexC), "Background", gc.getFatherInfo(self.MyFathers[iIndexC + (self.FatherColumn * 2)]).getPortrait(), (self.XResolution / 6) * iPosition - PortraitSize * 13 / 28 + extra_add, self.YResolution / 2 - self.YResolution / 7, PortraitSize * 3 / 5, PortraitSize * 3 / 5, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			#screen.addDDSGFCAt("Portrait Box" + str(iIndexC), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (self.XResolution / 6) * iPosition - PortraitSize * 21 / 48 + extra_add, PortraitSize * 3 / 4 + self.XResolution / 17, PortraitSize * 13 / 24, PortraitSize * 2 / 3, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
			screen.setImageButtonAt("Portrait Box" + str(iIndexC), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (self.XResolution / 6) * iPosition - PortraitSize * 21 / 48 + extra_add, self.YResolution / 2 - self.YResolution * 2 / 11, PortraitSize * 13 / 24, PortraitSize * 2 / 3, WidgetTypes.WIDGET_GENERAL, self.PICTURE_FF, iIndexC)
					
		iButtonClick = 0
					
	def handleInput(self, inputClass):

		if (inputClass.getNotifyCode() == NotifyCode.NOTIFY_CLICKED):

			if (inputClass.getButtonType() == WidgetTypes.WIDGET_GENERAL):

				if(inputClass.getData1() == 1):
					if ((self.lastIndex - 4) >= 0):
						self.ButtonClick = 1
						self.lastIndex -= 4
						self.drawContents()

				elif(inputClass.getData1() == 2):
					if ((self.lastIndex + 4) < len(self.MyFathers)):
						self.ButtonClick = 1
						self.lastIndex += 4
						self.drawContents()
				
				elif(inputClass.getData1() == self.PICTURE_FF):
						
						self.BIGFF = (inputClass.getData2())
						iFather = self.MyFathers[self.BIGFF + (self.FatherColumn * 2)]
						iFatherTurn = CyGame().getFatherGameTurn(iFather)
						iFatherYear = CyGame().getTurnYear(iFatherTurn)
						screen = self.getScreen()
						iRecordWidth = ((self.XResolution - 15) / 5) * 19 / 20
						PortraitSize = int(iRecordWidth * 1.25)
						screen.addDDSGFCAt("Big Portrait Black" + str(1), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_BLACK").getPath(),self.XResolution / 2 - ((PortraitSize * 2) / 2) , self.YResolution / 10, PortraitSize * 7 / 4 , PortraitSize * 2, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
						screen.addDDSGFCAt("Big Portrait" + str(1), "Background", gc.getFatherInfo(self.MyFathers[self.BIGFF + (self.FatherColumn * 2)]).getPortrait(), self.XResolution / 2 - ((PortraitSize * 41 / 16) / 2) , self.YResolution / 6, PortraitSize * 5 / 2, PortraitSize * 5 / 2, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
						#screen.addDDSGFCAt("Big Portrait Box" + str(1), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(), (self.XResolution / 6) * iPosition - PortraitSize * 21 / 48 + extra_add, PortraitSize * 3 / 4 + self.XResolution / 17, PortraitSize * 13 / 24, PortraitSize * 2 / 3, WidgetTypes.WIDGET_GENERAL, -1, -1, False)
						screen.setImageButtonAt("Big Portrait Box" + str(1), "Background", ArtFileMgr.getInterfaceArtInfo("INTERFACE_CONGRESS_BOX").getPath(),  self.XResolution / 2 - ((PortraitSize * 41 / 16) / 2) , self.YResolution / 22, PortraitSize * 5 / 2, PortraitSize * 5 / 2, WidgetTypes.WIDGET_GENERAL, self.BIG_PICTURE_FF, -1)
						screen.addDDSGFC("BigFatherShadow" + str(1), ArtFileMgr.getInterfaceArtInfo("INTERFACE_EUROPE_SHADOW_BOX").getPath(), self.XResolution / 60, self.YResolution / 25, self.XResolution * 4 / 17, self.YResolution / 4, WidgetTypes.WIDGET_GENERAL, -1, -1 )
						szFatherTitle = gc.getFatherInfo(iFather).getDescription() + u" (%d)" %iFatherYear
						screen.attachMultilineTextAt("BigFatherShadow" + "1", "BigFatherName" + str(1), szFatherTitle, 5, 15, self.XResolution * 2 / 9, (iRecordWidth * 18 / 100), WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_CENTER_JUSTIFY)
			
						#screen.addMultilineText("BigFatherName" + str(1), szFatherTitle, self.XResolution / 20, self.YResolution / 20, iRecordWidth, (iRecordWidth * 18 / 100), WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_CENTER_JUSTIFY)
						szFatherData = u"<font=3>" + CyGameTextMgr().getFatherHelp(iFather, True)[1:] + u"</font>"
						
						screen.attachMultilineTextAt("BigFatherShadow" + "1", "BigFatherData" + str(1), szFatherData, 5, 40, self.XResolution * 2 / 9, self.YResolution / 5, WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_CENTER_JUSTIFY)
			
						
				elif(inputClass.getData1() == self.BIG_PICTURE_FF):
						
						self.getScreen().hide("Big Portrait Box" + "1")
						self.getScreen().hide("Big Portrait" + "1")
						self.getScreen().hide("Big Portrait Black" + "1")
						self.getScreen().hide("BigFatherName" + "1")
						self.getScreen().hide("BigFatherData" + "1")
						self.getScreen().hide("BigFatherShadow" + "1")
							
						self.drawContents()
				
		return 0

	def update(self, fDelta):
		#if (CyInterface().isDirty(InterfaceDirtyBits.EuropeScreen_DIRTY_BIT)):
		#	CyInterface().setDirty(InterfaceDirtyBits.EuropeScreen_DIRTY_BIT, False)
			
		#	self.drawContents()

		return 0
	
	